unit NCAPI;

interface

uses
  Windows,Messages,SysUtils,Classes,Graphics,
  Controls,Forms,Dialogs,DdeMan;

type
  TNCAPI = class(TDdeClientConv)
  private
    fService:  string;
  protected

  public
    constructor Create(aOwner: TComponent); override;
    function WWWVersion: string;
    function WWWActivate(aWindowID: string): string;
    function WWWOpenURL(aURL: string): string;
  published
    property Service: string read fService write fService;
  end;

procedure Register;

implementation

constructor TNCAPI.Create(aOwner:TComponent);
begin
   inherited Create(aOwner);
   Service := 'NETSCAPE';
end;


function TNCAPI.WWWVersion: string;
var
   s: string;
begin
   s := '';
   SetLink(fService, 'WWW_Version');
   result:= StrPas(RequestData(s));
   CloseLink;
end;


function TNCAPI.WWWActivate(aWindowID: string): string;
begin
   if aWindowId = '' then
      aWindowID := '0xFFFFFFFF';
   SetLink(fService, 'WWW_Activate');
   result := StrPas(RequestData(aWindowID + ',0x0'));
   CloseLink;
end;


function TNCAPI.WWWOpenURL(aURL: string): string;
begin
   SetLink(fService, 'WWW_OpenURL');
   result := StrPas(RequestData(aURL + ',,0xFFFFFFFF'));
   CloseLink;
end;

procedure Register;
begin
  RegisterComponents('System', [TNCAPI]);
end;

end.
